/**
 * Response to serial data with sound added to
 * Space Junk by Ira and Danny Greenberg
 *
 * Rotating cubes in space using a custom Cube class. 
 * Color controlled by light sources.
 */

import processing.opengl.*;
//-------- Game HID variables --------
import org.gamecontrolplus.gui.*;
import org.gamecontrolplus.*;
import net.java.games.input.*;

ControlIO control;
ControlDevice stick;
float px, py;
//-------------------------------------

// Used for oveall rotation
float ang;
// Cube count-lower/raise to test P3D/OPENGL performance
int limit = 500;
// Array for all cubes
Cube[]cubes = new Cube[limit];

float xval, yval;         // for storing x and y of joystick
int redVal;               // y axis of game controller changes red value
int zAxis;

void setup() {
  size(1200, 900, OPENGL); 
  //-------------------  game controller code -----------
  surface.setTitle("This is fun!");
  // Initialise the ControlIO
  control = ControlIO.getInstance(this);
  // Find a joystick that matches the configuration file. To match with any 
  // connected device remove the call to filter.
  stick = control.filter(GCP.STICK).getMatchedDevice("joystick");
  if (stick == null) {
    println("No suitable device configured");
    System.exit(-1); // End the program NOW!
  }
  //-------------------------------------------------
  background(0); 
  noStroke();
   
  // Instantiate cubes, passing in random vals for size and postion
  for (int i = 0; i< cubes.length; i++){
    cubes[i] = new Cube(int(random(-10, 10)), int(random(-10, 10)), 
    int(random(-10, 10)), int(random(-140, 140)), int(random(-140, 140)), 
    int(random(-140, 140)));
  }

}
// Poll for user input called from the draw() method.
public void getUserInput() {
  px = map(stick.getSlider("X").getValue(), -1, 1, 0, width);
  py = map(stick.getSlider("Y").getValue(), -1, 1, 0, height);

}
void draw(){
  getUserInput(); // Polling the input device
  background(0); 
  fill(200);
   xval = map(px, 0, 1200, 400, 1200);
   yval = map(py, 0, 900, 0, 255);
   redVal = int(yval);
   zAxis = int(xval);         // then change position of junk

  // Set up some different colored lights
  pointLight(51, 102, 255, 65, 60, 100); 
  pointLight(redVal, 40, 60, -65, -60, -150);

  // Raise overall light in scene 
  ambientLight(80, redVal * .7, redVal * .4); 

  // Center geometry in display windwow.
  // you can change 3rd argument ('0')
  // to move block group closer(+)/further(-)
  translate(width/2, height/2, -200 + zAxis * 0.65);

  // Rotate around y and x axes
  rotateY(radians(ang));
  rotateX(radians(ang));

  // Draw cubes
  for (int i = 0; i < cubes.length; i++){
    cubes[i].drawCube();
  }
  
  // Used in rotate function calls above
  ang++;
}
